/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property;

import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.VWDesignerPreferences;
import filenet.vw.toolkit.design.canvas.process.VWDesignerBasePropertyPanel;
import filenet.vw.toolkit.design.canvas.process.VWPropertyActionMenu;
import filenet.vw.toolkit.design.canvas.process.VWPropertyMenuItem;
import filenet.vw.toolkit.design.canvas.process.diagram.VWDiagramProcessPropertyPanel;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.associations.VWAssociationPropertyPanel;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.routes.VWRoutePropertyPanel;
import filenet.vw.toolkit.design.property.steps.VWStepPropertyPanel;
import filenet.vw.toolkit.design.property.textannotations.VWTextAnnotationPropertyPanel;
import filenet.vw.toolkit.design.property.workflow.VWWorkflowPropPanel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import filenet.vw.toolkit.utils.images.VWBaseImageLoader;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.mapui.IVWMapItemsListener;
import filenet.vw.toolkit.utils.mapui.VWMapItemsEvent;
import filenet.vw.toolkit.utils.uicontrols.VWIconButton;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.IVWTabClosedListener;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.VWCloseableTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWDesignerPropertyPane
extends JPanel
implements ActionListener,
ItemListener,
IVWTabClosedListener,
ChangeListener,
IVWPropertyChangeListener,
IVWMapChangedListener,
IVWToolbarActionListener,
IVWMapItemsListener,
IVWCoordinationEventListener {
    protected VWDesignerBasePropertyPanel m_workflowPropertyPanel = null;
    protected Vector<VWDesignerBasePropertyPanel> m_stepPanelList = null;
    protected Vector<VWDesignerBasePropertyPanel> m_routePanelList = null;
    protected Vector<VWDesignerBasePropertyPanel> m_textAnnotationPanelList = null;
    protected Vector<VWDesignerBasePropertyPanel> m_associationPanelList = null;
    protected JPanel m_toolbarPanel = null;
    protected VWIconButton m_actionButton = null;
    protected VWPropertyActionMenu m_propertyActionMenu = null;
    protected AbstractButton m_helpButton = null;
    protected VWCloseableTabbedPane m_closeableTabbedPane = null;
    protected VWAuthPropertyData m_authPropertyData = null;
    protected String m_currentMapName = null;

    public void init(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_authPropertyData.setWorkflowPropertyPane(this);
            this.m_stepPanelList = new Vector();
            this.m_routePanelList = new Vector();
            this.m_textAnnotationPanelList = new Vector();
            this.m_associationPanelList = new Vector();
            this.createControls();
            this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
            this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
            this.m_authPropertyData.getSelectionChangeEventNotifier().addItemListener(this);
            this.m_authPropertyData.getToolbarActionNotifier().addToolbarActionListener(this);
            this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().addCoordinationEventListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void showWorkflowProperties() {
        this.showWorkflowProperties(-1, null);
    }

    public void showWorkflowProperties(int nErrorType, String itemName) {
        this.getWorkflowPropertiesPanel();
        if (this.m_workflowPropertyPanel != null) {
            if (this.m_closeableTabbedPane.indexOfComponent(this.m_workflowPropertyPanel) == -1) {
                this.m_closeableTabbedPane.removeChangeListener(this);
                this.m_closeableTabbedPane.addTab(this.m_workflowPropertyPanel.getDisplayName(), this.m_workflowPropertyPanel, false);
                this.m_closeableTabbedPane.addChangeListener(this);
            }
            if (nErrorType != -1) {
                int nTabIndex = ((VWWorkflowPropPanel)this.m_workflowPropertyPanel).lookupTabFromErrorType(nErrorType, itemName);
                ((VWWorkflowPropPanel)this.m_workflowPropertyPanel).showTab(nTabIndex, itemName);
            }
            this.m_closeableTabbedPane.setSelectedIndex(-1);
            this.m_closeableTabbedPane.setSelectedComponent(this.m_workflowPropertyPanel);
        }
    }

    public void showInheritedWorkflowInformation(boolean bShow) {
        this.m_authPropertyData.setShowInheritedProperties(bShow);
        if (this.m_workflowPropertyPanel != null) {
            ((VWWorkflowPropPanel)this.m_workflowPropertyPanel).reinitialize();
        }
    }

    public void fireTableActionNotification(int nEventId) {
        if (this.m_authPropertyData != null) {
            this.m_authPropertyData.getTableActionEventNotifier().notifyTableAction(nEventId);
        }
    }

    public boolean getIsDirty() {
        if (this.m_authPropertyData != null) {
            return this.m_authPropertyData.getIsDirty();
        }
        return false;
    }

    public void setIsDirty(boolean bIsDirty) {
        if (this.m_authPropertyData != null && bIsDirty) {
            this.m_authPropertyData.setDirty();
        }
    }

    public VWAuthPropertyData getAuthPropertyData() {
        return this.m_authPropertyData;
    }

    public void displayContextHelp() {
        Component selectedComponent = this.m_closeableTabbedPane.getSelectedComponent();
        if (selectedComponent != null && selectedComponent instanceof VWDesignerBasePropertyPanel) {
            ((VWDesignerBasePropertyPanel)selectedComponent).displayHelpPage();
        }
    }

    public void displayProperties(VWPropertyMenuItem menuItem) {
        if (menuItem != null) {
            this.displayTab(menuItem.getDataObject(), true);
            this.stateChanged(null);
        }
    }

    public void handleItemStateEvent(int nStateChange, Object[] items) {
        if (items[0] != null && nStateChange == 1) {
            if (items[0] instanceof VWWorkflowDefinition) {
                if (items.length > 1) {
                    int nErrorType = (Integer)items[1];
                    String name = (String)items[2];
                    this.showWorkflowProperties(nErrorType, name);
                }
            } else if (items[0] instanceof VWMapNode || items[0] instanceof VWRouteDefinition || items[0] instanceof VWTextAnnotationDefinition || items[0] instanceof VWAssociationDefinition) {
                if (items.length > 1 && items[1] instanceof String) {
                    String mapName = items[1].toString();
                    this.m_authPropertyData.getToolbarActionNotifier().notifyToolbarAction(this, 503, mapName);
                }
                this.displayTab(items[0], true);
            }
        }
    }

    public boolean closeAllTabs() {
        for (int nTabIndex = 0; nTabIndex < this.m_closeableTabbedPane.getTabCount(); ++nTabIndex) {
            Component component = this.m_closeableTabbedPane.getComponentAt(nTabIndex);
            if (component == null || !(component instanceof VWDesignerBasePropertyPanel)) continue;
            this.removeComponent((VWDesignerBasePropertyPanel)component, false);
        }
        this.m_closeableTabbedPane.removeAll();
        this.m_stepPanelList = new Vector();
        this.m_routePanelList = new Vector();
        this.m_textAnnotationPanelList = new Vector();
        this.m_associationPanelList = new Vector();
        this.showWorkflowProperties();
        return true;
    }

    public void releaseReferences() {
        this.m_authPropertyData.getMapChangeEventNotifier().removeMapChangedListener(this);
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        this.m_authPropertyData.getSelectionChangeEventNotifier().removeItemListener(this);
        this.m_authPropertyData.getToolbarActionNotifier().removeToolbarActionListener(this);
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().removeCoordinationEventListener(this);
        if (this.m_stepPanelList != null) {
            this.m_stepPanelList.removeAllElements();
            this.m_stepPanelList = null;
        }
        if (this.m_routePanelList != null) {
            this.m_routePanelList.removeAllElements();
            this.m_routePanelList = null;
        }
        if (this.m_textAnnotationPanelList != null) {
            this.m_textAnnotationPanelList.removeAllElements();
            this.m_textAnnotationPanelList = null;
        }
        if (this.m_associationPanelList != null) {
            this.m_associationPanelList.removeAllElements();
            this.m_associationPanelList = null;
        }
        if (this.m_closeableTabbedPane != null) {
            this.m_closeableTabbedPane.removeAll();
            this.m_closeableTabbedPane = null;
        }
        this.removeAll();
        if (this.m_workflowPropertyPanel != null) {
            this.m_workflowPropertyPanel.releaseReferences();
            this.m_workflowPropertyPanel = null;
        }
        this.m_authPropertyData = null;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_actionButton)) {
            if (this.m_propertyActionMenu == null) {
                this.m_propertyActionMenu = new VWPropertyActionMenu(this);
            }
            if (this.m_propertyActionMenu != null) {
                this.m_propertyActionMenu.setMap(this.m_currentMapName);
                this.m_propertyActionMenu.show(this.m_actionButton, this.m_actionButton.getWidth(), 0);
            }
        } else if (source.equals(this.m_helpButton)) {
            this.displayContextHelp();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        ItemSelectable itemSel = event.getItemSelectable();
        if (itemSel == null) {
            return;
        }
        Object[] items = itemSel.getSelectedObjects();
        if (items == null) {
            this.showWorkflowProperties();
            return;
        }
        this.handleItemStateEvent(event.getStateChange(), items);
    }

    public void closeOperation(int nTabIndex) {
        Component component = this.m_closeableTabbedPane.getComponentAt(nTabIndex);
        if (component != null && component instanceof VWDesignerBasePropertyPanel) {
            this.removeComponent((VWDesignerBasePropertyPanel)component, true);
        }
    }

    public void stateChanged(ChangeEvent event) {
        Component component = this.m_closeableTabbedPane.getSelectedComponent();
        if (component != null) {
            VWDesignerBasePropertyPanel propertyPanel = null;
            if (component instanceof VWDesignerBasePropertyPanel) {
                propertyPanel = (VWDesignerBasePropertyPanel)component;
            }
            if (propertyPanel != null) {
                this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().sendCoordinationEvent(this, 722, propertyPanel);
                this.m_authPropertyData.getSelectionChangeEventNotifier().notifySelectionChange(1, propertyPanel.getDataObject());
            }
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        block6: {
            try {
                Object object = event.getSource();
                if (!(object instanceof IVWPropertyChangeSource)) break block6;
                IVWPropertyChangeSource source = (IVWPropertyChangeSource)object;
                switch (event.getID()) {
                    case 501: 
                    case 503: 
                    case 572: 
                    case 577: {
                        Vector items = source.getItemsChanged();
                        for (int i = 0; i < items.size(); ++i) {
                            VWDesignerBasePropertyPanel tempPanel = this.findPropertyPanel(items.elementAt(i));
                            if (tempPanel == null) continue;
                            this.updateTabInformation(tempPanel);
                        }
                        break;
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public void mapChanged(VWMapChangedEvent event) {
        try {
            switch (event.getID()) {
                case 102: {
                    VWAssociationDefinition[] vwAssociationDefs;
                    VWTextAnnotationDefinition[] vwTextAnnotationDefs;
                    VWRouteDefinition[] vwRouteDefs;
                    VWMapNode[] vwMapNodes = this.m_authPropertyData.getMapChangeEventNotifier().getChangedSteps();
                    if (vwMapNodes != null && vwMapNodes.length > 0) {
                        for (int i = 0; i < vwMapNodes.length; ++i) {
                            VWDesignerBasePropertyPanel tempPanel = this.findPropertyPanel(vwMapNodes[i]);
                            if (tempPanel == null) continue;
                            this.removeComponent(tempPanel, false);
                        }
                    }
                    if ((vwRouteDefs = this.m_authPropertyData.getMapChangeEventNotifier().getChangedRoutes()) != null && vwRouteDefs.length > 0) {
                        for (int i = 0; i < vwRouteDefs.length; ++i) {
                            VWDesignerBasePropertyPanel tempPanel = this.findPropertyPanel(vwRouteDefs[i]);
                            if (tempPanel == null) continue;
                            this.removeComponent(tempPanel, false);
                        }
                    }
                    if ((vwTextAnnotationDefs = this.m_authPropertyData.getMapChangeEventNotifier().getChangedTextAnnotations()) != null && vwTextAnnotationDefs.length > 0) {
                        for (int i = 0; i < vwTextAnnotationDefs.length; ++i) {
                            VWDesignerBasePropertyPanel tempPanel = this.findPropertyPanel(vwTextAnnotationDefs[i]);
                            if (tempPanel == null) continue;
                            this.removeComponent(tempPanel, false);
                        }
                    }
                    if ((vwAssociationDefs = this.m_authPropertyData.getMapChangeEventNotifier().getChangedAssociations()) == null || vwAssociationDefs.length <= 0) break;
                    for (int i = 0; i < vwAssociationDefs.length; ++i) {
                        VWDesignerBasePropertyPanel tempPanel = this.findPropertyPanel(vwAssociationDefs[i]);
                        if (tempPanel == null) continue;
                        this.removeComponent(tempPanel, false);
                    }
                    break;
                }
                case 103: {
                    if (this.m_workflowPropertyPanel == null) break;
                    ((VWWorkflowPropPanel)this.m_workflowPropertyPanel).reinitialize();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarActionPerformed(VWToolbarActionEvent event) {
        switch (event.getID()) {
            case 502: {
                String newMapName = (String)event.getParam();
                if (VWStringUtils.compare(newMapName, this.m_currentMapName) == 0) break;
                this.closeAllTabs();
                this.m_currentMapName = newMapName;
                break;
            }
            case 670: {
                Object[] mapItems = (Object[])event.getParam();
                if (mapItems == null) break;
                for (int nIndex = 0; nIndex < mapItems.length; ++nIndex) {
                    this.displayTab(mapItems[nIndex], false);
                }
                break;
            }
        }
    }

    public void itemsAdded(VWMapItemsEvent event) {
        if (this.m_authPropertyData != null) {
            this.m_authPropertyData.getMapChangeEventNotifier().notifyItemsAdded(event.getItems());
        }
    }

    public void itemsRemoved(VWMapItemsEvent event) {
        if (this.m_authPropertyData != null) {
            this.m_authPropertyData.getMapChangeEventNotifier().notifyItemsRemoved(event.getItems());
        }
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        if (event.getSource() == this) {
            return;
        }
        switch (event.getID()) {
            case 709: {
                if (this.m_workflowPropertyPanel == null) break;
                ((VWWorkflowPropPanel)this.m_workflowPropertyPanel).reinitialize();
            }
        }
    }

    protected VWDesignerBasePropertyPanel getWorkflowPropertiesPanel() {
        if (this.m_workflowPropertyPanel == null) {
            this.m_workflowPropertyPanel = new VWWorkflowPropPanel(this.m_authPropertyData);
            this.updatePanelsComponentOrientation(this.m_workflowPropertyPanel);
        }
        return this.m_workflowPropertyPanel;
    }

    protected void updatePanelsComponentOrientation(JPanel canvasPanel) {
        try {
            if (canvasPanel != null) {
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                canvasPanel.applyComponentOrientation(compOrientation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void displayTab(Object dataObject, boolean bUsePreferences) {
        VWDesignerPreferences designerPrefs = this.m_authPropertyData.getDesignerCoreData().getDesignerPreferences();
        VWDesignerBasePropertyPanel propertyPanel = null;
        if (dataObject instanceof VWMapNode) {
            propertyPanel = this.findPropertyPanel(dataObject);
            if (propertyPanel == null && bUsePreferences && designerPrefs.getUseSameStepPropertyTab() && this.m_stepPanelList.size() > 0) {
                propertyPanel = this.m_stepPanelList.elementAt(0);
            }
            if (propertyPanel == null) {
                propertyPanel = new VWStepPropertyPanel(this.m_authPropertyData);
                this.m_stepPanelList.addElement(propertyPanel);
            }
        } else if (dataObject instanceof VWRouteDefinition) {
            propertyPanel = this.findPropertyPanel(dataObject);
            if (propertyPanel == null && bUsePreferences && designerPrefs.getUseSameRoutePropertyTab() && this.m_routePanelList.size() > 0) {
                propertyPanel = this.m_routePanelList.elementAt(0);
            }
            if (propertyPanel == null) {
                propertyPanel = new VWRoutePropertyPanel(this.m_authPropertyData);
                this.m_routePanelList.addElement(propertyPanel);
            }
        } else if (dataObject instanceof VWTextAnnotationDefinition) {
            propertyPanel = this.findPropertyPanel(dataObject);
            if (propertyPanel == null && bUsePreferences && designerPrefs.getUseSameTextAnnotationPropertyTab() && this.m_textAnnotationPanelList.size() > 0) {
                propertyPanel = this.m_textAnnotationPanelList.elementAt(0);
            }
            if (propertyPanel == null) {
                propertyPanel = new VWTextAnnotationPropertyPanel(this.m_authPropertyData);
                this.m_textAnnotationPanelList.addElement(propertyPanel);
            }
        } else if (dataObject instanceof VWAssociationDefinition) {
            propertyPanel = this.findPropertyPanel(dataObject);
            if (propertyPanel == null && bUsePreferences && designerPrefs.getUseSameAssociationPropertyTab() && this.m_associationPanelList.size() > 0) {
                propertyPanel = this.m_associationPanelList.elementAt(0);
            }
            if (propertyPanel == null) {
                propertyPanel = new VWAssociationPropertyPanel(this.m_authPropertyData);
                this.m_associationPanelList.addElement(propertyPanel);
            }
        }
        if (propertyPanel != null) {
            this.updatePanelsComponentOrientation(propertyPanel);
            propertyPanel.setDataObject(dataObject);
            if (this.m_closeableTabbedPane.indexOfComponent(propertyPanel) == -1) {
                this.m_closeableTabbedPane.removeChangeListener(this);
                this.m_closeableTabbedPane.addTab(propertyPanel.getDisplayName(), propertyPanel.getIcon(), propertyPanel, propertyPanel.getToolTip());
                this.m_closeableTabbedPane.addChangeListener(this);
            } else {
                this.updateTabInformation(propertyPanel);
            }
            this.m_closeableTabbedPane.removeChangeListener(this);
            this.m_closeableTabbedPane.setSelectedIndex(-1);
            this.m_closeableTabbedPane.setSelectedComponent(propertyPanel);
            this.m_closeableTabbedPane.addChangeListener(this);
        }
    }

    protected VWDesignerBasePropertyPanel findPropertyPanel(Object dataObject) {
        Vector<VWDesignerBasePropertyPanel> panelList = null;
        if (dataObject instanceof VWMapNode) {
            panelList = this.m_stepPanelList;
        } else if (dataObject instanceof VWRouteDefinition) {
            panelList = this.m_routePanelList;
        } else if (dataObject instanceof VWTextAnnotationDefinition) {
            panelList = this.m_textAnnotationPanelList;
        } else if (dataObject instanceof VWAssociationDefinition) {
            panelList = this.m_associationPanelList;
        }
        if (panelList != null) {
            for (int nIndex = 0; nIndex < panelList.size(); ++nIndex) {
                VWDesignerBasePropertyPanel tempPropertyPanel = panelList.elementAt(nIndex);
                if (dataObject != tempPropertyPanel.getDataObject()) continue;
                return tempPropertyPanel;
            }
        }
        return null;
    }

    protected void updateTabInformation(VWDesignerBasePropertyPanel propertyPanel) {
        if (propertyPanel == null) {
            return;
        }
        int nTabIndex = this.m_closeableTabbedPane.indexOfComponent(propertyPanel);
        if (nTabIndex != -1) {
            this.m_closeableTabbedPane.setTitleAt(nTabIndex, propertyPanel.getDisplayName());
            this.m_closeableTabbedPane.setIconAt(nTabIndex, propertyPanel.getIcon());
            this.m_closeableTabbedPane.setToolTipTextAt(nTabIndex, propertyPanel.getToolTip());
        }
    }

    protected boolean removeComponent(VWDesignerBasePropertyPanel propertyPanel, boolean bSelectNew) {
        Component selectedComponent;
        if (propertyPanel == null) {
            return false;
        }
        if (propertyPanel instanceof VWWorkflowPropPanel || propertyPanel instanceof VWDiagramProcessPropertyPanel) {
            return false;
        }
        Object dataObject = propertyPanel.getDataObject();
        Vector<VWDesignerBasePropertyPanel> panelList = null;
        if (dataObject instanceof VWMapNode) {
            panelList = this.m_stepPanelList;
        } else if (dataObject instanceof VWRouteDefinition) {
            panelList = this.m_routePanelList;
        } else if (dataObject instanceof VWTextAnnotationDefinition) {
            panelList = this.m_textAnnotationPanelList;
        } else if (dataObject instanceof VWAssociationDefinition) {
            panelList = this.m_associationPanelList;
        }
        this.m_closeableTabbedPane.removeChangeListener(this);
        this.m_closeableTabbedPane.remove(propertyPanel);
        this.m_closeableTabbedPane.addChangeListener(this);
        if (panelList != null) {
            panelList.remove(propertyPanel);
        }
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().sendCoordinationEvent(this, 723, propertyPanel);
        this.m_authPropertyData.getSelectionChangeEventNotifier().notifySelectionChange(2, propertyPanel.getDataObject());
        propertyPanel.releaseReferences();
        if (bSelectNew && (selectedComponent = this.m_closeableTabbedPane.getSelectedComponent()) != null) {
            propertyPanel = (VWDesignerBasePropertyPanel)selectedComponent;
            this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().sendCoordinationEvent(this, 722, propertyPanel);
            this.m_authPropertyData.getSelectionChangeEventNotifier().notifySelectionChange(1, propertyPanel.getDataObject());
        }
        return true;
    }

    private void createControls() {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder());
            this.m_toolbarPanel = this.getToolBarPanel();
            this.add((Component)this.m_toolbarPanel, "First");
            this.m_closeableTabbedPane = new VWCloseableTabbedPane();
            this.m_closeableTabbedPane.addTabClosedListener(this);
            this.m_closeableTabbedPane.addChangeListener(this);
            this.add((Component)this.m_closeableTabbedPane, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getToolBarPanel() {
        try {
            JPanel toolbarPanel = new JPanel(new GridBagLayout());
            toolbarPanel.setBorder(BorderFactory.createEmptyBorder());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_actionButton = new VWIconButton(VWResource.s_tabs, "property_action.gif");
            if (this.m_actionButton != null) {
                this.m_actionButton.addActionListener(this);
                this.m_actionButton.setName("m_actionButton_VWPropertyPanel");
                Font font = this.m_actionButton.getFont();
                if (font != null) {
                    font = new Font(font.getName(), 0, font.getSize() - 1);
                    this.m_actionButton.setFont(font);
                }
                toolbarPanel.add((Component)this.m_actionButton, gbCons);
            }
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            toolbarPanel.add((Component)new JLabel(" "), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_helpButton = VWImageLoader.createToolBarButton("help20.gif", VWResource.s_help, false);
            if (this.m_helpButton != null) {
                this.m_helpButton.addActionListener(this);
                this.m_helpButton.setName("m_helpButton_VWPropertyPanel");
                VWBaseImageLoader.enableIconComponentOrientation(this.m_helpButton);
                toolbarPanel.add((Component)this.m_helpButton, gbCons);
            }
            return toolbarPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

